/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWCalendarControlDialog;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeException;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeFormat;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class VWSIMOncePropertiesPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private JLabel m_dateLabel = null;
    private JTextField m_dateTextField = null;
    private JLabel m_timeLabel = null;
    private JTextField m_timeTextField = null;
    private JButton m_calendarButton = null;
    private JLabel m_durationLabel = null;
    private VWNumericTextField m_durationTextField = null;
    private JComboBox m_durationComboBox = null;
    private GridBagConstraints m_gridCons = null;
    private VWSIMPropertyData m_propertyData = null;
    private VWScenarioShiftDefinition m_shiftDef = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.m_gridCons = new GridBagConstraints();
        this.initDateTimeControls();
        this.initDurationControls();
        this.initSpacerControls();
    }

    public void setShiftDefinition(VWScenarioShiftDefinition shiftDef) {
        if (shiftDef != null) {
            this.m_shiftDef = shiftDef;
            this.reinitialize();
        }
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.m_calendarButton.setEnabled(enable);
        this.m_dateTextField.setEnabled(enable);
        this.m_durationComboBox.setEnabled(enable);
        this.m_durationTextField.setEnabled(enable);
        this.m_timeTextField.setEnabled(enable);
    }

    public void releaseReferences() {
        this.m_calendarButton = null;
        this.m_dateTextField = null;
        this.m_durationComboBox = null;
        this.m_durationTextField = null;
        this.m_timeTextField = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_durationComboBox) {
            this.performDurationComboBoxAction();
        } else if (src == this.m_calendarButton) {
            this.performCalendarButtonAction();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.m_dateTextField.getDocument() || doc == this.m_timeTextField.getDocument()) {
            this.updateDateTimeTextField();
        } else if (doc == this.m_durationTextField.getDocument()) {
            this.updateDurationTextField();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void initDateTimeControls() {
        this.m_dateLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_date));
        this.m_gridCons.gridx = 0;
        this.m_gridCons.gridy = 0;
        this.m_gridCons.fill = 0;
        this.m_gridCons.weightx = 0.0;
        this.m_gridCons.weighty = 0.0;
        this.m_gridCons.anchor = 21;
        this.m_gridCons.gridwidth = 1;
        this.m_gridCons.gridheight = 1;
        this.m_gridCons.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_dateLabel, this.m_gridCons);
        this.m_dateTextField = new JTextField();
        this.m_dateTextField.getDocument().addDocumentListener(this);
        this.m_dateTextField.setEditable(false);
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 2;
        this.m_gridCons.weightx = 0.3;
        this.m_gridCons.anchor = 23;
        this.add((Component)this.m_dateTextField, this.m_gridCons);
        this.m_timeLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_time));
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 0;
        this.m_gridCons.weightx = 0.0;
        this.m_gridCons.anchor = 21;
        this.add((Component)this.m_timeLabel, this.m_gridCons);
        this.m_timeTextField = new JTextField();
        this.m_timeTextField.getDocument().addDocumentListener(this);
        this.m_timeTextField.setEditable(false);
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 2;
        this.m_gridCons.weightx = 0.3;
        this.add((Component)this.m_timeTextField, this.m_gridCons);
        this.m_calendarButton = VWSIMImageLoader.createIconButton("calendar.gif", VWSIMResource.s_calendar);
        this.m_calendarButton.addActionListener(this);
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 0;
        this.m_gridCons.weightx = 0.4;
        this.add((Component)this.m_calendarButton, this.m_gridCons);
    }

    private void initDurationControls() {
        this.m_durationLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_duration));
        this.m_gridCons.gridx = 0;
        ++this.m_gridCons.gridy;
        this.m_gridCons.fill = 0;
        this.m_gridCons.weightx = 0.0;
        this.m_gridCons.weighty = 0.0;
        this.m_gridCons.anchor = 21;
        this.m_gridCons.gridwidth = 1;
        this.m_gridCons.gridheight = 1;
        this.m_gridCons.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_durationLabel, this.m_gridCons);
        this.m_durationTextField = new VWNumericTextField(6, 0, false);
        this.m_durationTextField.getDocument().addDocumentListener(this);
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 2;
        this.m_gridCons.weightx = 0.3;
        this.m_gridCons.anchor = 23;
        this.add((Component)this.m_durationTextField, this.m_gridCons);
        this.m_durationComboBox = new JComboBox();
        this.m_durationComboBox.addItem(VWSIMResource.s_seconds);
        this.m_durationComboBox.addItem(VWSIMResource.s_minutes);
        this.m_durationComboBox.addItem(VWSIMResource.s_hours);
        this.m_durationComboBox.setRenderer(new VWLabelListCellRenderer());
        this.m_durationComboBox.addActionListener(this);
        ++this.m_gridCons.gridx;
        this.m_gridCons.fill = 0;
        this.m_gridCons.weightx = 0.7;
        this.m_gridCons.anchor = 21;
        this.m_gridCons.gridwidth = 0;
        this.add((Component)this.m_durationComboBox, this.m_gridCons);
    }

    private void initSpacerControls() {
        this.m_gridCons.gridx = 0;
        ++this.m_gridCons.gridy;
        this.m_gridCons.fill = 1;
        this.m_gridCons.weightx = 1.0;
        this.m_gridCons.weighty = 1.0;
        this.m_gridCons.anchor = 23;
        this.m_gridCons.gridwidth = 0;
        this.m_gridCons.gridheight = 1;
        this.m_gridCons.insets = new Insets(5, 5, 5, 5);
        this.add((Component)new JLabel(), this.m_gridCons);
    }

    private void updateDateTimeTextField() {
        String dateTimeString = this.m_dateTextField.getText() + " " + this.m_timeTextField.getText();
        try {
            Date date = VWDateTimeFormat.getDateObject(dateTimeString);
            if (date != null) {
                this.m_shiftDef.setStartTime(date.getTime());
                this.m_propertyData.setDirty();
            }
        }
        catch (VWDateTimeException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performCalendarButtonAction() {
        String initDateString = this.m_dateTextField.getText();
        String initTimeString = this.m_timeTextField.getText();
        VWCalendarControlDialog calendarDlg = new VWCalendarControlDialog(this.m_propertyData.getParentFrame(), 102, initDateString + " " + initTimeString);
        calendarDlg.setVisible(true);
        int status = calendarDlg.getCloseStatus();
        if (status == 1) {
            Date date = calendarDlg.getDate();
            String dateString = VWDateTimeFormat.getDateString(date);
            String timeString = VWDateTimeFormat.getTimeString(date);
            this.m_dateTextField.setText(dateString);
            this.m_timeTextField.setText(timeString);
        }
    }

    private void updateDurationTextField() {
        try {
            String durationString = this.m_durationTextField.getText();
            this.m_shiftDef.getDuration().setDuration(durationString);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDurationComboBoxAction() {
        try {
            int durationUnit = 1;
            String durationUnitString = (String)this.m_durationComboBox.getSelectedItem();
            if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_seconds) == 0) {
                durationUnit = 1;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_minutes) == 0) {
                durationUnit = 2;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_hours) == 0) {
                durationUnit = 3;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_days) == 0) {
                durationUnit = 4;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_weeks) == 0) {
                durationUnit = 5;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_months) == 0) {
                durationUnit = 6;
            }
            this.m_shiftDef.getDuration().setUnits(durationUnit);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void reinitialize() {
        try {
            long dateTime = this.m_shiftDef.getStartTime();
            Date dateTimeObj = new Date(dateTime);
            this.m_dateTextField.getDocument().removeDocumentListener(this);
            this.m_dateTextField.setText(VWDateTimeFormat.getDateString(dateTimeObj));
            this.m_dateTextField.getDocument().addDocumentListener(this);
            this.m_timeTextField.getDocument().removeDocumentListener(this);
            this.m_timeTextField.setText(VWDateTimeFormat.getTimeString(dateTimeObj));
            this.m_timeTextField.getDocument().addDocumentListener(this);
            VWScenarioTimeDuration duration = this.m_shiftDef.getDuration();
            if (duration != null) {
                this.m_durationComboBox.removeActionListener(this);
                switch (duration.getUnits()) {
                    case 1: {
                        this.m_durationComboBox.setSelectedItem(VWSIMResource.s_seconds);
                        break;
                    }
                    case 2: {
                        this.m_durationComboBox.setSelectedItem(VWSIMResource.s_minutes);
                        break;
                    }
                    case 3: {
                        this.m_durationComboBox.setSelectedItem(VWSIMResource.s_hours);
                        break;
                    }
                    case 4: {
                        this.m_durationComboBox.setSelectedItem(VWSIMResource.s_days);
                        break;
                    }
                    case 5: {
                        this.m_durationComboBox.setSelectedItem(VWSIMResource.s_weeks);
                        break;
                    }
                    case 6: {
                        this.m_durationComboBox.setSelectedItem(VWSIMResource.s_months);
                    }
                }
                this.m_durationComboBox.addActionListener(this);
                this.m_durationTextField.getDocument().removeDocumentListener(this);
                this.m_durationTextField.setText(duration.getDuration());
                this.m_durationTextField.getDocument().addDocumentListener(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

